/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.license;

import ibm.nways.jdm.license.LicenseServiceInterface;
import ibm.nways.jdm.license.LicenseStatus;
import java.net.InetAddress;
import java.rmi.Naming;
import java.util.Date;
import java.util.Vector;

public class LicenseServiceClient {
    private LicenseServiceInterface licenseService;
    private boolean initialized = false;

    public boolean init(String string) {
        Integer n = new Integer(2099);
        try {
            String string2 = n.toString();
            System.out.println("@@@@LicenseService Client Port number: " + string2);
            if (string == null) {
                string = InetAddress.getLocalHost().getHostName();
            }
            this.licenseService = (LicenseServiceInterface)Naming.lookup("//" + string + ":" + string2 + "/LicenseService");
            System.out.println("@@@@LicenseService version: " + this.licenseService.getVersion());
        }
        catch (Exception exception) {
            System.out.println("@@@@LicenseServiceClient RMI exception:");
            exception.printStackTrace();
            return false;
        }
        this.initialized = true;
        return this.initialized;
    }

    public void startLicenseService() {
        if (!this.initialized) {
            this.init(null);
        }
        try {
            this.licenseService.startLicenseService();
            return;
        }
        catch (Exception exception) {
            System.out.println("LicenseService Exception:");
            exception.printStackTrace();
            return;
        }
    }

    public void stopLicenseService() {
        if (!this.initialized) {
            this.init(null);
        }
        try {
            this.licenseService.stopLicenseService();
            return;
        }
        catch (Exception exception) {
            System.out.println("LicenseService Exception:");
            exception.printStackTrace();
            return;
        }
    }

    public synchronized int getCount(String string) {
        if (!this.initialized) {
            this.init(null);
        }
        int n = 0;
        try {
            n = this.licenseService.getCount(string);
        }
        catch (Exception exception) {
            System.out.println("LicenseService Exception:");
            exception.printStackTrace();
        }
        return n;
    }

    public synchronized Date getExpirationDate(String string) {
        if (!this.initialized) {
            this.init(null);
        }
        Date date = null;
        try {
            date = this.licenseService.getExpirationDate(string);
        }
        catch (Exception exception) {
            System.out.println("LicenseService Exception:");
            exception.printStackTrace();
            date = new Date();
        }
        return date;
    }

    public synchronized int getRegistrationStatus(String string) {
        if (!this.initialized) {
            this.init(null);
        }
        int n = 0;
        try {
            n = this.licenseService.getRegistrationStatus(string);
        }
        catch (Exception exception) {
            System.out.println("LicenseService Exception:");
            exception.printStackTrace();
        }
        return n;
    }

    public synchronized LicenseStatus reserveLicense(String string, int n) {
        if (!this.initialized) {
            this.init(null);
        }
        LicenseStatus licenseStatus = null;
        try {
            licenseStatus = this.licenseService.reserveLicense(string, n);
        }
        catch (Exception exception) {
            System.out.println("LicenseService Exception:");
            exception.printStackTrace();
        }
        return licenseStatus;
    }

    public synchronized LicenseStatus reserveLicense(String string) {
        if (!this.initialized) {
            this.init(null);
        }
        LicenseStatus licenseStatus = null;
        try {
            licenseStatus = this.licenseService.reserveLicense(string);
        }
        catch (Exception exception) {
            System.out.println("LicenseService Exception:");
            exception.printStackTrace();
        }
        return licenseStatus;
    }

    public synchronized Vector getLicenseInfoList() {
        if (!this.initialized) {
            this.init(null);
        }
        Vector vector = null;
        try {
            vector = this.licenseService.getLicenseInfoList();
        }
        catch (Exception exception) {
            System.out.println("LicenseService Exception:");
            exception.printStackTrace();
        }
        return vector;
    }

    public synchronized Vector resetLicenseInfoList() {
        if (!this.initialized) {
            this.init(null);
        }
        Vector vector = null;
        try {
            vector = this.licenseService.resetLicenseInfoList();
        }
        catch (Exception exception) {
            System.out.println("LicenseService Exception:");
            exception.printStackTrace();
        }
        return vector;
    }
}

